package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.util.Date;

/**
 * @Author: tanglei
 * @Date: 2020-03-11 14:10
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PagePersonReqDTO extends BaseReqDTO {

    @ApiModelProperty("页码")
    private Integer pageNum;

    @ApiModelProperty("每页个数 最多50")
    private Integer pageSize;

    @ApiModelProperty("人员id")
    private String personGuid;

    @ApiModelProperty("人员姓名(支持模糊查询)")
    private String name;

    @ApiModelProperty("卡号（IC卡／身份证等，支持模糊搜索）")
    private String cardNo;

    @ApiModelProperty("手机号（支持模糊搜索）")
    private String phone;

    @ApiModelProperty("人员tag")
    private String tag;

    @ApiModelProperty("查询时间区间开始(UTC时间/毫秒值),如2018-08-08T08:18:28+0000或1542793088000")
    private String startTime;

    @ApiModelProperty("查询时间区间结束(UTC时间/毫秒值),如2018-08-08T08:18:28+0000或1542793088000")
    private String endTime;


}
