package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.util.List;

/**
 * @Author: tanglei
 * @Date: 2020-06-29 15:47
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PagePerBadgeReqDTO extends BaseReqDTO {

    @ApiModelProperty("页码")
    private Integer pageNum;

    @ApiModelProperty("每页个数")
    private Integer pageSize;

    @ApiModelProperty("信标卡片类型 0-手环 1-胸牌  2-卡片")
    private String badgeType;

    @ApiModelProperty("信标状态 0-在线  1-离线")
    private String badgeStatus;

    @ApiModelProperty("信标名称")
    private String badgeName;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("用户ids")
    private List<String> userIds;


}
