package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @Author: tanglei
 * @Date: 2020-03-23 11:23
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PageHistoryRecordReqDTO extends BaseReqDTO {

    @ApiModelProperty("页码")
    private Integer pageNum;

    @ApiModelProperty("每页个数 最多50")
    private Integer pageSize;

    @ApiModelProperty("员比对结果,1:比对成功 2:比对失败")
    @NotNull(message = "比对结果不能为空")
    private Byte type;

    @ApiModelProperty("人员id")
    private String personGuid;

    @ApiModelProperty("人员姓名(支持模糊查询)")
    private String personName;

    @ApiModelProperty("设备序列号")
    private String deviceKey;

    @ApiModelProperty("查询时间区间开始(UTC时间/毫秒值),如2018-08-08T08:18:28+0000或1542793088000")
    @NotNull(message = "开始时间不能为空")
    private Date startTime;

    @ApiModelProperty("查询时间区间结束(UTC时间/毫秒值),如2018-08-08T08:18:28+0000或1542793088000")
    @NotNull(message = "结束时间不能为空")
    private Date endTime;


    @ApiModelProperty("项目id")
    private String projectId;



}
