package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;

/**
 * @Author: tanglei
 * @Date: 2020-07-02 14:58
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PageGatewayInfoReqDTO extends BaseReqDTO {

    @ApiModelProperty("页码")
    private Integer pageNum;

    @ApiModelProperty("每页个数")
    private Integer pageSize;

    @ApiModelProperty("网关名称")
    private String gatewayName;

    @ApiModelProperty("网关编号")
    private String gatewayMacId;

    @ApiModelProperty("空间id")
    private String spaceId;

    @ApiModelProperty("项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

}


