package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.util.Date;

/**
 * @Author: tanglei
 * @Date: 2020-03-03 15:32
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PageDeviceReqDTO extends BaseReqDTO {

    @ApiModelProperty("页码")
    private Integer pageNum;

    @ApiModelProperty("每页个数 最多50")
    private Integer pageSize;

    @ApiModelProperty("设备序列号（支持模糊搜索）")
    private String deviceKey;

    @ApiModelProperty("设备名称（支持模糊搜索）")
    private String name;

    @ApiModelProperty("设备备注，开发者自定义传入")
    private String tag;

    @ApiModelProperty("设备类型 1:1代 2:2代 3:3代 6:c 10:2c")
    private Byte type;

    @ApiModelProperty("设备应用版本号")
    private String versionNo;

    @ApiModelProperty("识别方式 1:本地识别 2:云端识别")
    private Byte recType;

    @ApiModelProperty("设备状态 1:未绑定 2:已绑定 3:已禁用")
    private Byte state;

    @ApiModelProperty("查询时间区间开始(UTC时间/毫秒值)，如2018-08-08T08:18:28+0000或1542793088000")
    private String startTime;

    @ApiModelProperty("查询时间区间结束(UTC时间/毫秒值)，如2018-08-08T08:18:28+0000或1542793088000")
    private String endTime;

    @ApiModelProperty("项目id")
    private String projectId;


}
