package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2020/3/26 13:50
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class InsertCameraDTO extends BaseReqDTO {

    @ApiModelProperty("操作类型 1.新增 2.修改")
    private String type;

    @ApiModelProperty("摄像头id")
    private String cameraId;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("空间id")
    private String projectSpaceId;

    @ApiModelProperty("摄像头类型(1:普通，2:智能)")
    private String cameraCategoryId;

    @ApiModelProperty("摄像头名称")
    private String cameraName;

    @ApiModelProperty("摄像头对应模型名称")
    private String modelName;

    @ApiModelProperty("摄像头地址")
    private String cameraUrl;

    @ApiModelProperty("是否收藏（0否，1是）")
    private String isFavorite;

    @ApiModelProperty("数据点")
    private String dataPointId;

    @ApiModelProperty("摄像头对应物件名称")
    private String objectId;

    @ApiModelProperty("创建人id")
    private String createBy;

    @ApiModelProperty("更新人id")
    private String updateBy;

}
