package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.util.Date;

/**
 * @Author: tanglei
 * @Date: 2020-03-05 9:45
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class DevicePackageResDTO extends BaseReqDTO {

    @ApiModelProperty("创建时间")
    private Date creationTime;

    @ApiModelProperty("名称")
    private String description ;

    @ApiModelProperty("硬件类型 1:1代 2:2代 3:3代 6:C 10:2C")
    private Byte hardwareVersion;

    @ApiModelProperty("唯一标识")
    private String guid;

    @ApiModelProperty("平台类型")
    private Byte platform;

    @ApiModelProperty("版本类型 1:ota 2:app")
    private Byte type;

    @ApiModelProperty("固件包URL")
    private String url;

    @ApiModelProperty("版本号")
    private String versionNo;



}
