package com.ifourthwall.dbm.security.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

/**
 * @Author: tanglei
 * @Date: 2020-03-16 10:37
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class DeviceBatchBindDTO extends BaseReqDTO {

    @ApiModelProperty("设备序列号")
    private String deviceKey;

    @ApiModelProperty("人员guid,用\",\"拼接")
    private String personGuids;

    @ApiModelProperty("1:本地库 2:云端库")
    private Byte type;

    @ApiModelProperty("通过时间,范围为[00:00:00,23:59:59]，格式说明见备注")
    private String passTime;

    @ApiModelProperty("权限有效期 格式为毫秒值时间戳,使用\",\"拼接")
    private String permissionTime;

    @ApiModelProperty("人员权限 刷脸权限 1：无权限；2：有权限")
    private Integer facePermission;

    @ApiModelProperty("人员权限 刷卡权限 1：无权限；2：有权限")
    private Integer idCardPermission;

    @ApiModelProperty("人员权限 人卡合一权限 1：无权限；2：有权限")
    private Integer faceAndCardPermission;

    @ApiModelProperty("人员权限 人证比对权限 1：无权限；2：有权限")
    private Integer idCardFacePermission;

}
