package com.ifourthwall.dbm.security.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: tanglei
 * @Date: 2020-03-16 11:20
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class AuthResDTO implements Serializable {

    @ApiModelProperty("人员姓名")
    private String personName;

    @ApiModelProperty("人员guid")
    private String personGuid;

    @ApiModelProperty("设备名称")
    private String deviceName;

    @ApiModelProperty("设备序列号")
    private String deviceKey;

    @ApiModelProperty("设备类型 1:1代 2:2代 3:3代 6:C 90:无感系列 10: 2C")
    private Byte deviceType;

    @ApiModelProperty("识别方式 1:本地 2:云端")
    private Byte recType;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("识别库 1:本地 2:云端")
    private Byte type;

    @ApiModelProperty("通过时间")
    private String passTime;

    @ApiModelProperty("权限")
    private String permissionTime;

    @ApiModelProperty("权状态 1:待下发 2:待销权 3:已授权")
    private Byte state;

    @ApiModelProperty("人员权限 刷脸权限 1：无权限；2：有权限")
    private Integer facePermission;

    @ApiModelProperty("人员权限 刷卡权限 1：无权限；2：有权限")
    private Integer idCardPermission;

    @ApiModelProperty("人员权限 人卡合一权限 1：无权限；2：有权限")
    private Integer faceAndCardPermission;

    @ApiModelProperty("人员权限 人证比对权限 1：无权限；2：有权限")
    private Integer idCardFacePermission;

    @ApiModelProperty("人脸信息")
    private List<FaceWithStateResDTO> faceOutputs;


}
