package com.ifourthwall.dbm.provider.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.provider.dto.contacts.*;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/11/30 10:40
 * @Description:
 */
public interface UserContactsFacade {


    /**
     * 新增联系人
     * @param insert
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/11/30 10:35
     */
    BaseResponse insertContacts(InsertContactsDTO insert);


    /**
     * 修改联系人
     *
     * @param update
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/11/30 10:35
     */
    BaseResponse updateContacts(UpdateContactsDTO update);

    /**
     * 查询联系人
     *
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.provider.dto.contacts.QueryContactsDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/11/30 10:35
     */
    BaseResponse<List<QueryContactsDTO>> queryContacts(QueryContactsQuDTO queryContactsQuDTO);

    /**
     * 删除联系人
     *
     * @param delete
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     * @Author: YangPeng
     * @Date: 2020/11/30 10:36
     */
    BaseResponse deleteContacts(DeleteContactsDTO delete);
}
