package com.ifourthwall.dbm.provider.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.provider.dto.user.*;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/11/9 14:13
 * @Description:
 */
public interface EstateUserFacade {

    /**
     * userId、estateId查询不动产名字
     * @Author: YangPeng
     * @Date: 2020/11/9 14:16
     * @param upInsertProject
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<List<QueryEstateNameByUserIdDTO>> queryEstateNameByUserId(QueryEstateNameByUserIdBasisQuDTO upInsertProject);

    /**
     * 不动产名称模糊搜索
     * @Author: YangPeng
     * @Date: 2020/11/16 14:57
     * @param upInsertProject
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.provider.dto.user.SelectEstateNameDTO>>
     * @throws
     */
    BaseResponse<List<SelectEstateNameDTO>> selectEstateName(SelectEstateNameQuDTO upInsertProject);

    /**
     * 手机搜索userId
     * @Author: YangPeng
     * @Date: 2020/11/16 14:58
     * @param upInsertProject
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.user.SelectUserIdDTO>
     * @throws
     */
    BaseResponse<List<SelectUserIdDTO>> selectUserId(SelectUserIdQuDTO upInsertProject);

    /**
     * 查询用户信息
     * @Author: YangPeng
     * @Date: 2020/11/23 10:24
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.user.QueryUserInfoDTO>
     * @throws
     */
    BaseResponse<List<QueryUserInfoDTO>> queryUserInfo(QueryUserInfoQuDTO query);

    /**
     * 查询用户模块权限
     * @Author: YangPeng
     * @Date: 2020/11/23 17:09
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.provider.dto.user.QueryUserModeInfoDTO>
     * @throws
     */
    BaseResponse<QueryUserModeInfoDTO> queryUserModeInfo(QueryUserModeInfoQuDTO query);
}
