package com.ifourthwall.dbm.provider.dto.residence;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: YangPeng
 * @Date: 2020/9/14 11:17
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryResidenceInfoQuDTO extends BaseReqDTO {

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("住户id")
    private String residenceId;

    @ApiModelProperty("不动产id")
    private String estateId;

    @ApiModelProperty("住户人员id")
    @NotEmpty(message = PlatformCodeConstants.RESIDENCE_MEMBER_ID_NOT_NULL)
    private String residenceMemberId;
}
