package com.ifourthwall.dbm.provider.dto.merchant;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.dbm.provider.dto.AnnexDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/11/3 17:21
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class UpdateMerchantAnnexDTO extends BaseReqDTO {

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("不动产id")
    private String estateId;

    @ApiModelProperty("商户id")
    private String merchantId;

    @ApiModelProperty("创建者user_id")
    private String updateBy;

    @ApiModelProperty("合同附件")
    private List<AnnexDTO> merchantAnnexList;

    @ApiModelProperty("其他附件")
    private List<AnnexDTO> annexList;
}
