package com.ifourthwall.dbm.provider.dto.merchant;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: YangPeng
 * @Date: 2020/9/7 13:50
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryMerchantBasisInfoQuDTO extends BaseReqDTO {

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("商户id")
    @NotEmpty(message = PlatformCodeConstants.MERCHANT_ID_NOT_NULL)
    private String merchantId;

    @ApiModelProperty("不动产id")
    @NotEmpty(message = PlatformCodeConstants.ESTATE_ID_NOT_NULL)
    private String estateId;
}
