package com.ifourthwall.dbm.provider.dto.merchant;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.dbm.provider.dto.AnnexDTO;
import com.ifourthwall.dbm.provider.dto.enclosure.EnclosureDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/9/2 16:03
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class InsertMerchantDTO extends BaseReqDTO {

    @ApiModelProperty("商户名称")
    @NotEmpty(message = PlatformCodeConstants.NAME_NOT_NULL)
    private String merchantName;

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("商户经营类型（1.餐饮 2.教育 3.服饰 4.娱乐 5.服务 6.体育用品 7.文具用品 8.其他）")
    private String merchantBusinessTypeId;

    @ApiModelProperty("商户规模")
    private String merchantScale;

    @ApiModelProperty("营业执照")
    private List<String> businessLicensePics;

    @ApiModelProperty("其他证照")
    private List<String> otherPics;

    @ApiModelProperty("商户性质（1.企业  2.个人）")
    private String merchantCharacterTypeId;

    @ApiModelProperty("商户状态（1.营业中 2.停业 3.退租  4.未入场 5.装修中 6.转租中 7.出租中 8.出售中 9.其他）")
    @NotEmpty(message = PlatformCodeConstants.STATUS_NOT_NULL)
    private String merchantStatusId;

    @ApiModelProperty("负责人名称")
    @NotEmpty(message = PlatformCodeConstants.CHARGE_NAME_NOT_NULL)
    private String merchantChargeName;

    @ApiModelProperty("负责人联系方式")
    @NotEmpty(message = PlatformCodeConstants.CHARGE_PHONE_NOT_NULL)
    private String merchantChargePhone;

    @ApiModelProperty("负责人身份证")
    private String merchantChargeIdCard;

    @ApiModelProperty("有效期限")
    private Date contractBegin;

    @ApiModelProperty("入住时间")
    private Date contractEnd;

    @ApiModelProperty("小程序背景图")
    private String backgroundPic;

    @ApiModelProperty("工商登记号")
    private String businessNumber;

    @ApiModelProperty("是否成立党支部 1.是 2.否")
    private String partyBranch;

    @ApiModelProperty("党员人数")
    private Long communistNumber;

    @ApiModelProperty("免费车位数")
    private Long freeCarsNumber;

    @ApiModelProperty("租赁车位数")
    private Long leaseCarsNumber;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建者user_id")
    private String createBy;

    @ApiModelProperty("空间id")
    @NotEmpty(message = PlatformCodeConstants.SPACE_ID_NOT_NULL)
    private List<String> spaceId;

    @ApiModelProperty("合同附件")
    private List<EnclosureDTO> enclosureList;

}
