package com.ifourthwall.dbm.provider.dto.member;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.dbm.provider.dto.PageCommonExTDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2020/10/10 15:03
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryResidenceMemberPageQuDTO extends PageCommonExTDTO {

    @ApiModelProperty("住户id")
    @NotEmpty(message = PlatformCodeConstants.RESIDENCE_ID_NOT_NULL)
    private String residenceId;

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("名称搜索")
    private String nameLike;

    @ApiModelProperty("手机搜索")
    private String phoneLike;

    @ApiModelProperty("开始时间")
    private Date beginTime;

    @ApiModelProperty("结束时间")
    private Date endTime;

}
