package com.ifourthwall.dbm.provider.dto.enclosure;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/11/3 17:21
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class UpdateEnclosureDTO extends BaseReqDTO {

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("不动产id")
    @NotEmpty(message = PlatformCodeConstants.ESTATE_ID_NOT_NULL)
    private String estateId;

    @ApiModelProperty("创建者user_id")
    private String createBy;

    @ApiModelProperty("合同附件")
    private List<EnclosureDTO> enclosureList;

}
