package com.ifourthwall.dbm.provider.dto.enclosure;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * @Author: YangPeng
 * @Date: 2020/12/3 13:51
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class EstateAnnexDTO implements Serializable {

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    /**
     * 不动产类别（1.商户 2.住户）
     */
    private String estateCategory;


    /**
     * 住户id
     */
    private String residenceId;

    @ApiModelProperty("不动产id")
    private String estateId;

    @ApiModelProperty("商户id")
    private String merchantId;
}
