package com.ifourthwall.dbm.provider.dto.employee;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * @Author: YangPeng
 * @Date: 2020/9/25 18:08
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class UpdateMerchantEmployeeDTO extends BaseReqDTO {

    @ApiModelProperty("商户id")
    @NotEmpty(message = PlatformCodeConstants.MERCHANT_ID_NOT_NULL)
    private String merchantId;

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("商户人员id")
    @NotEmpty(message = PlatformCodeConstants.MERCHANT_EMPLOYEE_ID_NOT_NULL)
    private String merchantEmployeeId;

    @ApiModelProperty("商户人员状态（1.在职 2.离职）")
    @NotEmpty(message = PlatformCodeConstants.MERCHANT_EMPLOYEE_STATUS_NOT_NULL)
    private String merchantEmployeeStatusId;

    @ApiModelProperty("用户关系id")
    private String userRelationshipId;

    @ApiModelProperty("商户人员姓名")
    private String merchantEmployeeName;

    @ApiModelProperty("商户人员电话")
    private String merchantEmployeePhone;

    @ApiModelProperty("商户人员编号")
    private String merchantEmployeeNumber;

    @ApiModelProperty("商户人员身份证")
    private String merchantEmployeeIdCard;

    @ApiModelProperty("商户人员角色类型(1.业主 2.管理员 3.普通员工)")
    private String merchantEmployeeRoleTypeId;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建者user_id")
    private String updateBy;

}
