package com.ifourthwall.dbm.provider.dto.employee;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: YangPeng
 * @Date: 2020/9/23 17:52
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class InsertMerchantEmployeeDTO extends BaseReqDTO {

    @ApiModelProperty("商户id")
    @NotEmpty(message = PlatformCodeConstants.MERCHANT_ID_NOT_NULL)
    private String merchantId;

    @ApiModelProperty("项目id")
    @NotEmpty(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("不动产id")
    @NotEmpty(message = PlatformCodeConstants.ESTATE_ID_NOT_NULL)
    private String estateId;

    @ApiModelProperty("商户人员姓名")
    @NotEmpty(message = PlatformCodeConstants.NAME_NOT_NULL)
    private String merchantEmployeeName;

    @ApiModelProperty("商户人员电话")
    @NotEmpty(message = PlatformCodeConstants.PHONE_NOT_NULL)
    private String merchantEmployeePhone;

    @ApiModelProperty("商户人员编号")
    private String merchantEmployeeNumber;

    @ApiModelProperty("商户人员身份证")
    private String merchantEmployeeIdCard;

    @ApiModelProperty("商户人员角色类型(1.业主 2.管理员 3.普通员工)")
    private String merchantEmployeeRoleTypeId;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人")
    private String createBy;

}
