package com.ifourthwall.dbm.project.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.project.dto.*;
import com.ifourthwall.dbm.project.dto.project.*;

import java.util.List;

/**
 * @Author: hao.dai
 * @Date: 2019/10/18 17:26
 * @Description:
 */
public interface ProjectFacade {

    /**
     * 新增修改项目
     * @Author: YangPeng
     * @Date: 2019/11/13 15:18
     * @param upInsertProject
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse upInsertProject(UpInsertProjectDTO upInsertProject);

    /**
     * 查询项目
     * @Author: YangPeng
     * @Date: 2019/11/14 16:20
     * @param queryProject
     * @return com.ifourthwall.common.base.BaseResponse<com.github.pagehelper.PageInfo<com.ifourthwall.dbm.project.dto.QueryProjectPageDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryPageProjectDTO>> queryProjectPage(QueryProjectPageQueryDTO queryProject);

    /**
     * 查询空间名称
     * @Author: YangPeng
     * @Date: 2019/11/15 15:55
     * @param projectSpaceInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.GetProjectSpaceInfoDTO>
     * @throws
     */
    BaseResponse<QueryProjectPageDTO> getProjectSpaceInfo(GetProjectSpaceInfoQueryDTO projectSpaceInfo);

    /**
     * 获取项目及空间统计信息
     * @Author: YangPeng
     * @Date: 2019/11/15 15:55
     * @param projectSpaceInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.GetProjectSpaceInfoDTO>
     * @throws
     */
    BaseResponse<QueryProjectPageDTO> getProjectInfo(GetProjectSpaceInfoQueryDTO projectSpaceInfo);

    /**
     * 项目首字母数据填充
     * @Author: YangPeng
     * @Date: 2019/11/15 16:56
     * @param
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse fillingInitials();

    /**
     * 根据部门id查询项目集合
     * @Author: YangPeng
     * @Date: 2019/11/18 15:29
     * @param queryDept
     * @return com.ifourthwall.common.base.BaseResponse<com.github.pagehelper.PageInfo<com.ifourthwall.dbm.project.dto.QueryProjectPageDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryProjectPageDTO>> queryDept(QueryDeptQueryDTO queryDept);

    /**
     * 新增/修改/删除部门下的项目
     * @Author: YangPeng
     * @Date: 2019/11/19 16:29
     * @param queryDept
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse upInsertDeptProject(InsertDeptProjectQueryDTO queryDept);

    /**
     * 查询租户是否有项目的操作权限
     * @Author: YangPeng
     * @Date: 2019/11/21 11:21
     * @param permission
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Boolean>
     * @throws
     */
    BaseResponse<Boolean> permission(PermissionDTO permission);

    /**
     * 查询翻译的配置字段
     * @Author: YangPeng
     * @Date: 2019/11/26 13:43
     * @param translation
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.QueryAllDeployDTO>
     * @throws
     */
    BaseResponse<QueryAllDeployDTO> queryAllDeploy(TranslationDTO translation);



    /**
     * 项目空间列表
     * @Author: YangPeng
     * @Date: 2019/12/30 20:13
     * @param projectSpaceList
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.project.dto.ProjectSpaceListDTO>>
     * @throws
     */
    BaseResponse<PageDTO<ProjectSpaceListDTO>> projectSpaceList(ProjectSpaceListQueryDTO projectSpaceList);

    /**
     * 查询项目下所有部门
     * @Author: YangPeng
     * @Date: 2020/1/2 10:22
     * @param allDeptQuery
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.QueryAllDeptDTO>
     * @throws
     */
    BaseResponse<List<QueryAllDeptDTO>> queryAllDept(QueryAllDeptQueryDTO allDeptQuery);

    /**
     * 查询部门绑定项目列表
     * @Author: YangPeng
     * @Date: 2020/1/10 11:55
     * @param bindProject
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.PageDTO<com.ifourthwall.dbm.project.dto.QueryBindProjectDTO>>
     * @throws
     */
    BaseResponse<PageDTO<QueryBindProjectDTO>> queryBindProject(QueryBindProjectQuDTO bindProject);

    /**
     * 查询部门未绑定项目列表
     * @Author: YangPeng
     * @Date: 2020/1/11 18:09
     * @param noBindProject
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.PageDTO<com.ifourthwall.dbm.project.dto.QueryBindProjectDTO>>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryBindProjectDTO>> queryNoBindProject(QueryNoBindProjectQuDTO noBindProject);

    /**
     * 查询项目所绑定的部门
     * @param query
     * @return
     */
    BaseResponse<List<ProjectBindDeptDTO>> projectBindDept(ProjectBindDeptQueryDTO query);


    /**
     * 查询城市对应的天气城市id
     * @Author: YangPeng
     * @Date: 2020/3/4 14:14
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.WeatherCityIdDTO>
     * @throws
     */
    BaseResponse<WeatherCityIdDTO> weatherCityId(WeatherCityIdQueryDTO query);

    /**
     * 查询部门绑定项目 分页
     * @Author: YangPeng
     * @Date: 2020/6/9 14:15
     * @param queryDept
     * @return java.util.List<com.ifourthwall.dbm.project.bo.QueryAllDeptBO>
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryAllDeptDTO>> queryPageAllDept(QueryAllDeptQueryDTO queryDept);

    /**
     * 通过projectIds查询项目信息
     * @Author: YangPeng
     * @Date: 2020/8/31 14:18
     * @param queryList
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.project.dto.project.QueryListByIdsDTO>>
     * @throws
     */
    BaseResponse<List<QueryListByIdsDTO>> queryListByIds(QueryListByIdsQuDTO queryList);

    /**
     * 通过projectIds查询项目国家位置
     * @Author: YangPeng
     * @Date: 2020/10/12 14:33
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.project.QueryCountryIdDTO>
     * @throws
     */
    BaseResponse<QueryCountryIdDTO> queryCountryId(QueryCountryIdQuDTO query);

    /**
     * 查询所有项目
     * @Author: YangPeng
     * @Date: 2021/2/22 15:26
     * @param
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.project.QueryAllProjectDTO>
     * @throws
     */
    BaseResponse<List<QueryAllProjectDTO>> queryAllProject();
}
