package com.ifourthwall.dbm.project.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/26 10:25
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class SpaceMergeQueryDTO extends BaseReqDTO {

    @ApiModelProperty("空间名字")
    private String spaceName;

    @ApiModelProperty("目标空间")
    @NotNull(message = "目标空间不能为空")
    private String aimsSpace;

    @ApiModelProperty("需要合并的空间")
    @NotNull(message = "需要合并的空间不能为空")
    private List<String> mergeSpace;

    @ApiModelProperty("项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("父级空间id")
    @NotNull(message = "父级空间id不能为空")
    private String pSpaceId;

    @ApiModelProperty("操作人")
    private String updateBy;

}
