package com.ifourthwall.dbm.project.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/11/14 15:32
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryProjectPageQueryDTO extends PageCommonExTDTO {

    @ApiModelProperty("业态(1:园区、2:工业、3:住宅、4:商业、5:办公、6:综合体、7: 酒店、8:学校、9:医院、10:政府、11:租赁式项目、12:自有资产)")
    private String categoryId;

    @ApiModelProperty("  状态（1:启用，2:停用）")
    private String statusId;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("开始时间")
    private String beginTime;

    @ApiModelProperty("结束时间")
    private String endTime;

    @ApiModelProperty("排序 1.升序 2.降序，默认为降序")
    private Integer sort;

    @ApiModelProperty("项目id")
    private List<String> projectIds;


//      此查询条件保留，因为没有该查询需求。
//    @ApiModelProperty("是否有效 0 - 生效 1 - 未生效 2 - 删除")
//    private String valid;

}
