package com.ifourthwall.dbm.project.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2020/1/9 16:26
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryDeptProjectListDTO {


    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private String projectId;


    /**
     * 业态(1:园区、2:工业、3:住宅、4:商业、5:办公、6:综合体、7: 酒店、8:学校、9:医院、10:政府、11:租赁式项目、12:自有资产)
     */
    @ApiModelProperty("业态(1:园区、2:工业、3:住宅、4:商业、5:办公、6:综合体、7: 酒店、8:学校、9:医院、10:政府、11:租赁式项目、12:自有资产)")
    private String projectCategoryId;

    /**
     * 负责人，对应userid
     */
    @ApiModelProperty("负责人，对应userid")
    private String projectLeaderUserId;

    /**
     * 项目编号（6位）
     */
    @ApiModelProperty("项目编号")
    private String projectCode;

    /**
     * 乡镇/区id
     */
    @ApiModelProperty("乡镇/区id")
    private String zoneId;

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projectName;

    /**
     * 项目名称首字母(拼音)
     */
    @ApiModelProperty("项目名称首字母(拼音)")
    private String projectPrefixLetter;

    /**
     *   状态（1:启用，2:停用）
     */
    @ApiModelProperty("  状态（1:启用，2:停用）")
    private String projectStatusId;

    /**
     * 优先级1 2 3 4
     */
    @ApiModelProperty("优先级1 2 3 4")
    private String projectLvlId;

    /**
     * 项目简称
     */
    @ApiModelProperty("项目简称")
    private String projectShortName;

    /**
     * 占地面积
     */
    @ApiModelProperty("占地面积")
    private BigDecimal floorArea;

    /**
     * 收费面积
     */
    @ApiModelProperty("收费面积")
    private BigDecimal chargeArea;

    /**
     * 建筑面积
     */
    @ApiModelProperty("建筑面积")
    private BigDecimal buildingArea;

    /**
     * 物业公司名称
     */
    @ApiModelProperty("物业公司名称")
    private String propertyMgntCompanyName;

    /**
     * 业主名称
     */
    @ApiModelProperty("业主名称")
    private String proprietorName;

    /**
     * 开发上名称
     */
    @ApiModelProperty("开发上名称")
    private String developerName;

    /**
     * 项目地址
     */
    @ApiModelProperty("项目地址")
    private String projectAddress;

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    private BigDecimal lng;

    /**
     * 维度
     */
    @ApiModelProperty("纬度")
    private BigDecimal lat;

    /**
     * 项目icon
     */
    @ApiModelProperty("项目icon")
    private String projectIconUrl;

    /**
     * 到期日期(空表示永久)
     */
    @ApiModelProperty("到期日期(空表示永久)")
    private Date expiredTime;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 初次接触时间
     */
    @ApiModelProperty("初次接触时间")
    private Date firstContactTime;

    /**
     * 项目类型名称
     */
    @ApiModelProperty("项目类型名称")
    private String projectCategoryName;

    /**
     *项目状态名称
     */
    @ApiModelProperty("项目状态名称")
    private String projectStatusName;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private Date createTime;
}
