package com.ifourthwall.dbm.project.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

@Data
@ToString(callSuper=true)
public class ProjectSpaceSubListQueryDTO extends BaseReqDTO {

    @ApiModelProperty("空间id集合")
    private List<String> ids;

    @ApiModelProperty("项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("父级id")
    private List<String> pid;

    @ApiModelProperty("名字搜索")
    private String nameLike;

    @ApiModelProperty("搜索的模块名称")
    private String modelName;

    @ApiModelProperty("等级")
    private Integer spaceLvl;

    @ApiModelProperty("objectId")
    private List<String> objectId;

    @ApiModelProperty("需要排除的id")
    private List<String> notExistId;

}
