package com.ifourthwall.dbm.project.dto.project;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2021/2/22 15:25
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryAllProjectDTO implements Serializable {
    /**
     * 流水号
     */
    private Long id;

    /**
     * 是否有效 0 - 生效 1 - 未生效 2 - 删除
     */
    private String valid;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 公司id
     */
    private String companyId;

    /**
     * 业态(1:园区、2:工业、3:住宅、4:商业、5:办公、6:综合体、7: 酒店、8:学校、9:医院、10:政府、11:租赁式项目、12:自有资产)
     */
    private String projectCategoryId;

    /**
     * 负责人，对应userid
     */
    private String projectLeaderUserId;

    /**
     * 项目编号（6位）
     */
    private String projectCode;

    /**
     * 乡镇/区id
     */
    private String zoneId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目名称首字母(拼音)
     */
    private String projectPrefixLetter;

    /**
     * 状态（1:启用，2:停用）
     */
    private String projectStatusId;

    /**
     * 优先级1 2 3 4 5
     */
    private String projectLvlId;

    /**
     * 项目简称
     */
    private String projectShortName;

    /**
     * 占地面积
     */
    private BigDecimal floorArea;

    /**
     * 收费面积
     */
    private BigDecimal chargeArea;

    /**
     * 建筑面积
     */
    private BigDecimal buildingArea;

    /**
     * 物业公司名称
     */
    private String propertyMgntCompanyName;

    /**
     * 物业公司电话
     */
    private String propertyPhone;

    /**
     * 业主名称
     */
    private String proprietorName;

    /**
     * 开发商名称
     */
    private String developerName;

    /**
     * 项目地址
     */
    private String projectAddress;

    /**
     * 经度
     */
    private BigDecimal lng;

    /**
     * 纬度
     */
    private BigDecimal lat;

    /**
     * 业主方
     */
    private String projectBusinessOwner;

    /**
     * 项目icon
     */
    private String projectIconUrl;

    /**
     * 到期日期(空表示永久)
     */
    private Date expiredTime;

    /**
     * 备注
     */
    private String remark;

    /**
     * 初次接触时间
     */
    private Date firstContactTime;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人(user_id)
     */
    private String createBy;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人(user_id)
     */
    private String updateBy;

}
