package com.ifourthwall.dbm.project.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.dbm.project.util.CheckRegexpUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/11/13 14:39
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class UpInsertProjectDTO extends BaseReqDTO {

    @ApiModelProperty("类型 1.新增 2.修改")
    private Integer type;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("公司id")
    private String companyId;

    @ApiModelProperty("业态(1:园区、2:工业、3:住宅、4:商业、5:办公、6:综合体、7: 酒店、8:学校、9:医院、10:政府、11:租赁式项目、12:自有资产)")
    private String projectCategoryId;

    @ApiModelProperty("负责人，对应userid")
    private String projectLeaderUserId;

    @ApiModelProperty("乡镇/区id")
    @NotNull(message = "乡镇/区id不能为空")
    private String zoneId;

    @ApiModelProperty("项目名称")
    @NotNull(message = "项目名称不能为空")
    private String projectName;

    @ApiModelProperty("  状态（1:启用，2:停用）")
    @NotNull(message = "状态不能为空")
    private String projectStatusId;

    @ApiModelProperty("优先级1 2 3 4")
    @NotNull(message = "优先级不能为空")
    private String projectLvlId;

//    @ApiModelProperty("项目简称")
//    private String projectShortName;

    @ApiModelProperty("占地面积")
    private BigDecimal floorArea;

    @ApiModelProperty("收费面积")
    private BigDecimal chargeArea;

    @ApiModelProperty("建筑面积")
    private BigDecimal buildingArea;

    @ApiModelProperty("物业公司名称")
    private String propertyMgntCompanyName;

    @ApiModelProperty("物业公司电话")
    private String propertyPhone;

    @ApiModelProperty("业主名称")
    private String proprietorName;

    @ApiModelProperty("开发商名称")
    private String developerName;

    @ApiModelProperty("项目地址")
    private String projectAddress;

    @ApiModelProperty("经度")
    private BigDecimal lng;

    @ApiModelProperty("维度")
    private BigDecimal lat;

    @ApiModelProperty("项目icon")
    private String projectIconUrl;

    @ApiModelProperty("备注")
    private String remark;

//    @ApiModelProperty("初次接触时间")
//    @NotNull(message = "初次接触时间不能为空")
//    private Date firstContactTime;

    @ApiModelProperty("创建人(user_id)")
    private String createBy;

    @ApiModelProperty("更新人(user_id)")
    private String updateBy;

    //以下为各种图片的存储使用

    @ApiModelProperty("seer端使用的图片")
    private String seerPicture;

    @ApiModelProperty("项目图片")
    private String webPicture;

//    @ApiModelProperty("项目证书名")
//    private List<CertDTO> certificateName;

    @ApiModelProperty("业主方")
    private String projectBusinessOwner;

    @ApiModelProperty("附件")
    private List<ProjectAnnexQuDTO> annexList;



}
