package com.ifourthwall.dbm.project.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.project.dto.GetZoneListDTO;
import com.ifourthwall.dbm.project.dto.GetZoneListQueryDTO;
import com.ifourthwall.dbm.project.dto.GetZoneInfoQueryDTO;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/11/25 13:55
 * @Description:
 */
public interface ZoneFacade  {

    /**
     * 查询区域列表
     * @Author: YangPeng
     * @Date: 2019/11/25 13:55
     * @param getZoneList
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.project.dto.GetZoneListDTO>>
     * @throws
     */
    BaseResponse<List<GetZoneListDTO>> getZoneList(GetZoneListQueryDTO getZoneList);

    /**
     * 查询区域详情
     * @Author: YangPeng
     * @Date: 2019/11/25 15:18
     * @param getZoneInfo
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.project.dto.GetZoneListDTO>
     * @throws
     */
    BaseResponse<GetZoneListDTO> getZoneInfo(GetZoneInfoQueryDTO getZoneInfo);
}
