package com.ifourthwall.dbm.project.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author: YangPeng
 * @Date: 2019/11/22 15:35
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class SortSpaceQueryDTO extends BaseReqDTO {

    @ApiModelProperty("类型1.向上 2.向下")
    @NotNull(message = "类型不能为空")
    private String Type;

    @ApiModelProperty("被调换的空间父级id")
    private String targetPId;

    @ApiModelProperty("被调换的空间id")
    private String targetSpaceId;

    @ApiModelProperty("被调换的空间id对应的rank")
    private Integer targetRankId;

    @ApiModelProperty("需要修改的空间id")
    private String spaceId;

    @ApiModelProperty("需要修改的空间id对应的rank")
    private Integer rankId;

    @ApiModelProperty("更新人(user_id)")
    private String updateBy;
}
