package com.ifourthwall.dbm.project.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: YangPeng
 * @Date: 2020/1/10 11:28
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryBindProjectDTO implements Serializable {


    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("负责人，对应userid")
    private String projectLeaderUserId;

    @ApiModelProperty("乡镇/区id")
    private String zoneId;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("状态（1:已接触，2:已立项，）")
    private String projectStatus;

    @ApiModelProperty("状态名字（1:已接触，2:已立项，）")
    private String projectStatusName;

    @ApiModelProperty("负责人名字")
    private String projectLeaderUserName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("省市区")
    private GetZoneListDTO regionName;

    @ApiModelProperty("观察者(0.非观察者 1.观察者)")
    private String observerId;

}
