package com.ifourthwall.dbm.project.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/11/19 15:40
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class InsertDeptProjectQueryBasisDTO extends BaseReqDTO {

    @ApiModelProperty("操作类型 1.绑定 2.解绑")
    @NotNull(message = PlatformCodeConstants.TASK_OPERATE_TYPE_CANNOT_NULL)
    private String type;

    @ApiModelProperty("部门Id")
    @NotNull(message = "部门Id不能为空")
    private String deptId;

    @ApiModelProperty("项目信息")
    private List<InsertDeptProjectInfoDTO> projectInfo;

    @ApiModelProperty("创建人id")
    private String createBy;

    @ApiModelProperty("更新人id")
    private String updateBy;

}
