package com.ifourthwall.dbm.project.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/11/9 18:06
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QuerySonTagBaseDTO implements Serializable {

    @ApiModelProperty(value = "主键")
    private String projectSpaceId;

    @ApiModelProperty(value = "空间名称")
    private String projectSpaceName;

    @ApiModelProperty(value = "模型名")
    private String u3dModelId;

    @ApiModelProperty(value = "安全状态（0正常1故障）")
    private Integer securityStatus = 0;

    @ApiModelProperty(value = "设备状态（0正常1故障）")
    private Integer assetStatus = 0;

    @ApiModelProperty(value = "商户状态（0正常1故障）")
    private Integer merchantStatus = 0;

    @ApiModelProperty(value = "所有空间id")
    private List<String> allSpaceIds;

}
