package com.ifourthwall.dbm.objects.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.objects.dto.*;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/3/9 16:38
 * @Description:
 */
public interface ObjectsFacade {

    /**
     * 批量插入模型名
     * @Author: YangPeng
     * @Date: 2019/12/2 11:04
     * @param upInsertAsset
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertObjectName(InsertObjectNameQuDTO upInsertObject);

    /**
     * 查询模型名
     * @Author: YangPeng
     * @Date: 2020/3/11 9:34
     * @param upInsertObject
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.objects.dto.ModelNameDTO>>
     * @throws
     */
    BaseResponse<List<ModelNameDTO>> queryModelName(QuModelNameQuDTO upInsertObject);

    /**
     * 插入object
     * @Author: YangPeng
     * @Date: 2019/12/2 11:04
     * @param insertObject
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertObject(InsertObjectDTO insertObject);

    /**
     * 批量新增物件
     * @Author: YangPeng
     * @Date: 2020/8/26 14:56
     * @param insertObject
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertObjectList(List<InsertObjectListDTO> insertObject);

    /**
     * 删除object
     * @Author: YangPeng
     * @Date: 2019/12/2 11:04
     * @param deleteObject
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteObject(DeleteObjectDTO deleteObject);

    /**
     * 更新object
     * @Author: YangPeng
     * @Date: 2019/12/2 11:04
     * @param upInsertAsset
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse updateObject(InsertObjectDTO upInsertObject);

    /**
     * 查询物件列表
     * @Author: YangPeng
     * @Date: 2019/12/2 11:04
     * @param queryList
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<IFWPageInfo<ObjectListDTO>> queryList(QueryListQuDTO queryList);


    BaseResponse excelInsertObject(ExcelInsertObjectDTO queryList);


    BaseResponse deleteByProject(DeleteByProjectDTO queryList);


    /**
     * 根据物件id查询模型名
     *
     * @param query
     * @param user
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.objects.dto.QueryModelNameDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/5/14 10:24
     */
    BaseResponse<List<QueryModelNameDTO>> queryModelName(QueryModelNameQuDTO query);

}
