package com.ifourthwall.dbm.objects.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.objects.dto.*;

import java.util.List;

/**
 * @Author: tanglei
 * @Date: 2020-03-27 11:51
 * @Description:
 */
public interface ModelRepositoryFacade {

    /**
     * 插入objectRepository
     * @Param: insertObjectRepositoryDTO
     * @Return:
     * @Author: tanglei
     * @Date: 2020/3/27 11:08
     */
    BaseResponse insertModelRepository(InsertObjectRepositoryDTO insertObjectRepositoryDTO);


    /**
     * 更新objectRepository
     * @Param: updateObjectRepositoryDTO
     * @Return:
     * @Author: tanglei
     * @Date: 2020/3/27 11:37
     */
    BaseResponse updateModelRepository(UpdateObjectRepositoryDTO updateObjectRepositoryDTO);


    /**
     * 删除objectRepository
     * @Param: deleteObjectRepositoryDTO
     * @Return:
     * @Author: tanglei
     * @Date: 2020/3/27 11:37
     */
    BaseResponse deleteModelRepository(DeleteObjectRepositoryDTO deleteObjectRepositoryDTO);


  /**
   * 更新模型名
   * @Author: YangPeng
   * @Date: 2020/4/8 17:37
   * @param updateName
   * @return com.ifourthwall.common.base.BaseResponse
   * @throws
   */
    BaseResponse updateName(UpdateObjectNameDTO updateName);

}
