package com.ifourthwall.dbm.asset.dto.seer.energy;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/7/27 13:36
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryEnergyComparedGraphQuDTO extends BaseReqDTO {

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("返回数据格式 1.小时 2.日 3.月")
    private String type;

    @NotNull(message = "数据点id不能为空")
    @ApiModelProperty("数据点id")
    private List<String> dataPointId;

    @NotNull(message = "开始时间不能为空")
    private Date startTime;

    @NotNull(message = "结束时间不能为空")
    private Date endTime;
}
