package com.ifourthwall.dbm.asset.dto.checkpoint;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: YangPeng
 * @Date: 2020/8/3 13:58
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryCheckPointTagInfoQuDTO extends BaseReqDTO {

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("点位id")
    @NotEmpty(message = PlatformCodeConstants.CHECKPOINT_NOT_NULL)
    private String checkPointId;

    @ApiModelProperty("资产分类0 - 设备 1 - 设施")
    private String assetCategory;
}
