package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.dbm.asset.Util.CheckRegexpUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import lombok.ToString;
import org.hibernate.validator.constraints.Length;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/11/29 18:04
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class UpInsertAssetQueryDTO extends BaseReqDTO {

    @ApiModelProperty("操作类型:1.新增；2.修改")
    @NotNull(message = "操作类型不能为空")
    private Integer type;

    @ApiModelProperty("资产id")
    private String assetId;

    @ApiModelProperty("图片")
    private String pictureUrl;

    @ApiModelProperty("资产名称")
    @NotNull(message = "资产名称不能为空")
    private String assetName;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("项目空间id")
    private String projectSpaceId;

    @ApiModelProperty("u3d模型id")
    private String u3dModelId;

    @ApiModelProperty("资产编号")
    @Length(min = 1,max = 20,message = "资产编号长度不规范")
    @Pattern(regexp = "^$|^[0-9a-zA-Z\u4e00-\u9fa5\\.\\_\\-\\(\\/\\)]+$", message = "资产编号不规范")
    private String assetCode;

    @ApiModelProperty("生产厂家")
    private String factory;

    @ApiModelProperty("生产日期")
    private Date manufactureDate;

    @ApiModelProperty("资产型号")
    @Length(max = 20,message = "规格型号长度不规范")
    private String assetModel;

    @ApiModelProperty("使用年限")
    private Integer assetLifetime;

    @ApiModelProperty("购买时间")
    private Date purchaseTime;

    @ApiModelProperty("资产原值 元")
    private BigDecimal assetOriginalValue;

    @ApiModelProperty("维保供应商名称")
    private String maintenanceSupplierName;

    @ApiModelProperty("维保供应商电话")
    private String maintenanceSupplierTel;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建者user_id")
    private String createBy;

    @ApiModelProperty("更新者user_id")
    private String updateBy;

    @ApiModelProperty("设备故障列表")
    private List<FaultItemDTO> FaultItem;

    @ApiModelProperty("设备事件列表")
    private List<MaintenanceItemDTO> MaintenanceItem;

    //3.1.0新增内容

    @ApiModelProperty("质保到期时间")
    private Date assetQualityMaturityTime;

    @ApiModelProperty("负责人电话")
    private String assetPrincipalPhone;

    @ApiModelProperty("所属系统")
    private String assetFacilityTagId;

    @ApiModelProperty("附件")
    private List<AssetAnnexQuDTO> annexList;

    @ApiModelProperty("资产工单状态 0.正常;1.维护中")
    private String assetTaskStatus;

    @ApiModelProperty("抄表 0.非抄表设备 ; 1.抄表设备")
    private String assetEnableCheckMeter;

    @ApiModelProperty("是否是特种设备 0.非特种设备 ; 1.特种设备")
    private String specialEquipmentId;

    @ApiModelProperty("资产分类0 - 设备 1 - 设施")
    @NotNull(message = "资产分类不能为空")
    private String assetCategory;

//    @ApiModelProperty("资产状态 1.正常;2.异常")
//    private String assetStatus;

    @ApiModelProperty("设备类型id")
    private String assetEquipmentTypeId;

    @ApiModelProperty("资产系统id")
    private String assetSystemId;

    @ApiModelProperty("资产类型")
    private String assetTagId;

}
