package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;

/**
 * @Author: YangPeng
 * @Date: 2019/12/12 15:06
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryMonitorListQueryDTO extends PageCommonExTDTO {

    @ApiModelProperty("项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("空间id")
    private String spaceId;

    @ApiModelProperty("空间名称")
    private String spaceName;

    @ApiModelProperty("监控状态 1.正常;2.异常")
    private String assetStatus;

    @ApiModelProperty("监控名字")
    private String assetName;

    @ApiModelProperty("资产分类0 - 设备 1 - 设施")
    private String assetCategory;

    @ApiModelProperty("排序 1逆序，2顺序")
    private String sort;

    @ApiModelProperty("是否展示子集空间")
    private String isOrNot;

    @ApiModelProperty("系统id")
    private String assetSystemId;

    @ApiModelProperty("设备类型id")
    private String assetEquipmentTypeId;

    @ApiModelProperty("抄表")
    private String assetEnableCheckMeter;


}
