package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/16 18:23
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryMonitorListDoQueryDTO extends PageCommonExTDTO {

    @ApiModelProperty("项目id")
    @NotNull(message = "项目id不能为空")
    private String projectId;

    @ApiModelProperty("空间id")
    private List<String> spaceId;

    @ApiModelProperty("监控对象id")
    private List<String> monitorTargetId;

    @ApiModelProperty("监控状态 1.正常;2.异常")
    private String assetStatus;

    @ApiModelProperty("监控名字")
    private String assetName;

    @ApiModelProperty("排序 1逆序，2顺序")
    private String sort;

    @ApiModelProperty("系统id")
    private String assetSystemId;

    @ApiModelProperty("资产id")
    private List<String> assetId;

    @ApiModelProperty("设备类型id")
    private String assetEquipmentTypeId;

    @ApiModelProperty("抄表")
    private String assetEnableCheckMeter;
}
