package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/5 15:06
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryCheckPointListQueryBaseDTO extends PageCommonExTDTO {
    @ApiModelProperty("项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

    @ApiModelProperty("部门id")
    private List<String> deptIds;

    @ApiModelProperty("点位id")
    private List<String> checkPointId;

    @ApiModelProperty("空间id")
    private String spaceId;

    @ApiModelProperty("点位名字")
    private String checkPointName;

    @ApiModelProperty("排序1倒叙 2正序 默认倒叙")
    private Integer Sort;
}
