package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/3 14:58
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryAssetListQueryDTO extends PageCommonExTDTO {

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("空间id")
    private List<String> spaceId;

    @ApiModelProperty("资产类型 0 - 设备 1 - 设施")
    private String assetCategory;

    @ApiModelProperty("排序 1逆序，2顺序")
    private String sort;

    @ApiModelProperty("系统标签id")
    private String assetTagId;

    @ApiModelProperty("系统id")
    private String assetFacilityTagId;

    @ApiModelProperty("资产名字")
    private String assetName;

    @ApiModelProperty("资产Id")
    private List<String> assetId;

    @ApiModelProperty("开始时间")
    private String updateTime;

    @ApiModelProperty("资产工单状态 0.在用;1.维护中；2.停用")
    private String assetTaskStatus;

    @ApiModelProperty("资产系统id")
    private String assetSystemId;

    @ApiModelProperty("资产类型id")
    private String assetEquipmentTypeId;

    @ApiModelProperty("抄表 0.非抄表设备 ; 1.抄表设备")
    private String assetEnableCheckMeter;

    @ApiModelProperty("是否是特种设备 0.非特种设备 ; 1.特种设备")
    private String specialEquipmentId;


}
