package com.ifourthwall.dbm.asset.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/12/3 16:03
 * @Description:
 */
@Data
@ToString(callSuper=true)
public class QueryAssetEquipmentListDTO implements Serializable {

    @ApiModelProperty("资产id")
    private String assetId;

    @ApiModelProperty("资产名称")
    private String assetName;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("项目空间id")
    private String projectSpaceId;

    @ApiModelProperty("项目空间名称")
    private String projectSpaceName;

    @ApiModelProperty("图片")
    private String pictureUrl;

    @ApiModelProperty("u3d模型id")
    private String u3dModelId;

    @ApiModelProperty("资产型号")
    private String assetModel;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("资产状态 1.正常;2.异常")
    private String assetStatus;

    @ApiModelProperty("创建者user_id")
    private String createBy;

    @ApiModelProperty("创建者名字")
    private String createName;

    @ApiModelProperty("资产工单状态 0.在用;1.维护中；2.停用")
    private String assetTaskStatus;

    @ApiModelProperty("资产工单状态 0.在用;1.维护中；2.停用")
    private String assetTaskStatusName;

    @ApiModelProperty("抄表 0.非抄表设备 ; 1.抄表设备")
    private String assetEnableCheckMeter;

    @ApiModelProperty("是否是特种设备 0.非特种设备 ; 1.特种设备")
    private String specialEquipmentId;

    @ApiModelProperty("设备类型id")
    private String assetEquipmentTypeId;

    @ApiModelProperty("设备类型名称")
    private String equipmentTypeName;

    @ApiModelProperty("资产系统id")
    private String assetSystemId;

    @ApiModelProperty("资产系统名称")
    private String systemName;
}
