package com.ifourthwall.dbm.estate.facade.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author: YangPeng
 * @Date: 2019/9/29 16:13
 * @Description:
 */
@Data
public class MerchantListSeerQueryDTO implements Serializable {

    @ApiModelProperty(value = "项目id")
    @NotNull(message = "项目id不能为空")
    private Integer projectId;

    @ApiModelProperty(value = "商户类型（1.商铺 2. 餐饮 3.办公 4.工作室 5.办事处 6.其他）")
    private Integer merchantType;

    @ApiModelProperty(value = "账单（1.已结清 2.未结清）")
    private Integer billStatus;

    @ApiModelProperty(value = "搜索内容")
    private String search;

}
