package com.ifourthwall.dbm.estate.facade.dto;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: xuye
 * @Date: 2019/8/31 10:44
 * @Description:
 */
@Data
public class ManagerCompleteBillQueryDTO implements Serializable {

    /**
     * 账单目标类型，1业主账单
     */
    @NotNull(message = "账单目标类型，1业主账单不能为空")
    private Integer billTargetType;

    /**
     * 账单目标id
     */
    @NotNull(message = "账单目标id不能为空")
    private String billTargetId;


    /**
     * 支付方式(1微信，2支付宝，3现金，4银行卡)
     */
    @NotNull(message = "支付方式(1微信，2支付宝，3现金，4银行卡)不能为空")
    private Integer paymentCategory;

    /**
     * 支付时间
     */
    @NotNull(message = "支付时间不能为空")
    private Date paymentAt;

    /**
     * 支付图片（用户上传的图片）
     */
    @NotNull(message = "支付图片（用户上传的图片）不能为空")
    private String paymentPics;


    /**
     * 操作人id
     */
    @NotNull(message = "操作人id不能为空")
    private Integer actionUserId;

}
