package com.ifourthwall.dbm.estate.facade.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author: xuye
 * @Date: 2019/9/26 14:40
 * @Description:
 */
@Data
public class EstateResidenceSeerSummaryDTO implements Serializable {

    @ApiModelProperty("住宅总数")
    private Integer residenceCount;

    @ApiModelProperty("在线登记数")
    private Integer residenceOwnerCount;

    @ApiModelProperty("已缴住户数")
    private Integer payedCount;

    @ApiModelProperty("待缴住户数")
    private Integer unExpireCount;

    @ApiModelProperty("逾期住户数")
    private Integer expireCount;


    public Integer getResidenceCount() {
        return residenceCount == null ? 0 : residenceCount;
    }

    public Integer getResidenceOwnerCount() {
        return residenceOwnerCount == null ? 0 : residenceOwnerCount;
    }

    public Integer getPayedCount() {
        return payedCount == null ? 0 : payedCount;
    }

    public Integer getUnExpireCount() {
        return unExpireCount == null ? 0 : unExpireCount;
    }

    public Integer getExpireCount() {
        return expireCount == null ? 0 : expireCount;
    }
}
