package com.ifourthwall.dbm.estate.facade.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: yangpeng
 * @Date: 2019/8/27 09:54
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class EstatePropertUpdateDTO implements Serializable {

    @ApiModelProperty(value = "不动产id")
    private String estateId;

    @ApiModelProperty(value = "住宅规格")
    private String residenceCategory;

    @ApiModelProperty("建筑面积")
    private BigDecimal buildingArea;

    @ApiModelProperty("使用面积")
    private BigDecimal usingArea;

    @ApiModelProperty("公用面积")
    private BigDecimal publicArea;

    @ApiModelProperty(value = "负责人名称")
    private String chargeName;

    @ApiModelProperty(value = "负责人联系方式")
    private String chargePhone;

    @ApiModelProperty(value = "负责人身份证")
    private String chargeIdCard;

    @ApiModelProperty(value = "更新人")
    private Integer updateBy;

}
