package com.ifourthwall.dbm.estate.facade.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.security.SecureRandom;

/**
 * @Author: xuye
 * @Date: 2019/9/27 17:19
 * @Description:
 */
@Data
public class EstateBillSummaryDTO implements Serializable {

    @ApiModelProperty("需要支付的月份")
    private String needPayYearMonth;

    @ApiModelProperty("账单总数")
    private Integer totalCount;

    @ApiModelProperty("已缴费数量")
    private Integer payCount;

    @ApiModelProperty("未缴费且未逾期数量")
    private Integer unPayCount;

    @ApiModelProperty("未缴费且已逾期数量")
    private Integer unPayExpireCount;

    public Integer getTotalCount() {
        return totalCount == null ? 0 : totalCount;
    }

    public Integer getPayCount() {
        return payCount == null ? 0 : payCount;
    }

    public Integer getUnPayCount() {
        return unPayCount == null ? 0 : unPayCount;
    }

    public Integer getUnPayExpireCount() {
        return unPayExpireCount == null ? 0 : unPayExpireCount;
    }
}
