package com.ifourthwall.dbm.estate.facade.dto;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @Author: xuye
 * @Date: 2019/9/2 11:37
 * @Description:
 */
@Data
public class EstateBillListDTO extends EstateBillBaseDTO implements Serializable {

    /**
     * 业务状态（1：未缴未逾期，2：未缴已逾期，3已缴，4已删除）
     */
    private Integer bizStatus;

    /**
     * 不动产类型（1:商户，2：住户）
     */
    private Integer estateCategory;

    /**
     * 不动产名称
     */
    private String estateName;

    /**
     * 负责人名称
     */
    private String chargeName;

    /**
     * 负责人联系方式
     */
    private String chargePhone;

    /**
     * 项目id
     */
    private Integer projectId;

    /**
     * 空间id
     */
    private List<Integer> spaceIds;
}
