package com.ifourthwall.dbm.estate.facade;

import com.github.pagehelper.PageInfo;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.estate.facade.dto.*;

import java.util.List;

/**
 * @Author: xuye
 * @Date: 2019/8/28 13:14
 * @Description:
 */
public interface EstateBillFacade {

    /**
     * 新增账单
     * @Author: xuye
     * @Date: 2019/8/28 11:40
     * @param queryDTO
     * @return java.lang.Integer
     * @throws
     */
    BaseResponse<Integer> insertEstateBill(EstateBillInsertQueryDTO queryDTO);


    /**
     * 修改账单
     * @Author: xuye
     * @Date: 2019/8/28 18:48
     * @param queryDTO
     * @return java.lang.Integer
     * @throws
     */
    BaseResponse<Integer> updateEstateBill(EstateBillBaseUpdateQueryDTO queryDTO);

    /**
     * 删除账单
     * @Author: xuye
     * @Date: 2019/8/28 18:51
     * @param idDTO
     * @return java.lang.Integer
     * @throws
     */
    BaseResponse<Integer> delEstateBill(CommonIdUserIdDTO idDTO);

    /**
     * 管理者直接完成账单
     * @Author: xuye
     * @Date: 2019/8/31 11:39
     * @param queryDTO
     * @return com.ifourthwall.common.base.BaseResponse<java.lang.Integer>
     * @throws
     */
    BaseResponse<Integer> updateManagerCompleteBill(ManagerCompleteBillQueryDTO queryDTO);

    /**
     * 分页查询账单列表
     * @Author: xuye
     * @Date: 2019/9/2 10:58
     * @param queryDTO
     * @return com.github.pagehelper.PageInfo<com.ifourthwall.dbm.estate.bo.EstateBillListBO>
     * @throws
     */
    BaseResponse<PageInfo<EstateBillListDTO>> getBillPage(EstateBillListQueryDTO queryDTO);

    /**
     * 查询账单统计信息，按月份分组
     * @Author: xuye
     * @Date: 2019/9/27 17:27
     * @param query
     * @return com.ifourthwall.dbm.estate.bo.EstateBillSummaryBO
     * @throws
     */
    BaseResponse<List<EstateBillSummaryDTO>> getBillSummary(EstateBillSummaryQueryDTO query);


}
