package com.ifourthwall.dbm.estate.facade;

import com.github.pagehelper.PageInfo;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.estate.facade.dto.*;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2019/8/30 11:56
 * @Description:
 */
public interface EstateBasisFacade {

    /**
     * 查询不动产信息
     * @Author: YangPeng
     * @Date: 2019/9/17 13:37
     * @param ids
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<EstateDTO> queryEstateByIds(EstateOwnerDTO ids);

    /**
     * 查询不动产住宅信息
     * @Author: YangPeng
     * @Date: 2019/9/17 13:38
     * @param id
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<EstateResidenceDTO> queryResidence(EstateOwnerDTO id);

    /**
     * 插入审核信息
     * @Author: YangPeng
     * @Date: 2019/9/17 13:44
     * @param infoDTO
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<Integer> insertReviewInfo(EstateReviewInfoDTO infoDTO);

    /**
     * 查询审核历史列表
     * @Author: YangPeng
     * @Date: 2019/9/17 13:44
     * @param listDTO
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<PageInfo<EstateExamineListDTO>> queryReviewList(EstateReviewListDTO listDTO);

    /**
     * 按照项目id和不动产类型，模糊搜索查询不动产列表
     * @Author: YangPeng
     * @Date: 2019/9/17 13:44
     * @param projectId
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<List<EstateSpaceDTO>> queryOwnerListById(EstateOwnerListDTO projectId);

}
